#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("ggpubr")


#library packages
library(limma)
library(ggpubr)
tideFile="TIDE.txt"          #TIDE file
groupFile="metabolismcluster.txt"          #group file
setwd("E:\\metabolism\\LGG\\8.TIDE")     

#Read TIDE data
tide=read.table(tideFile, header=T, sep="\t", check.names=F, row.names=1)
row.names(tide)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", row.names(tide))
tide=avereps(tide)

#Read group data file
group=read.table(groupFile, header=T, sep="\t", check.names=F, row.names=1)

#data merge
sameSample=intersect(row.names(tide), row.names(group))
tide=tide[sameSample, , drop=F]
group=group[sameSample, "group", drop=F]
data=cbind(tide, group)

#Set up the comparison group
data$group=ifelse(data$group=="C1", "C1", "C2")
group=levels(factor(data$group))
data$group=factor(data$group, levels=c("C1", "C2"))
group=levels(factor(data$group))
comp=combn(group,2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#Loop the tide score and draw the violin plot separately
for(i in colnames(data)[1:(ncol(data)-1)]){
  gg1=ggviolin(data, x="group", y=i, fill = "group", 
               xlab="", ylab=i,
               palette=c("#16797E","#EABC4B"),
               legend.title="metabolismcluster",
               add = "boxplot", add.params = list(fill="white"))+ 
    stat_compare_means(comparisons = my_comparisons,symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "ns")),label = "p.signif")
  
  pdf(file=paste0("violin.", i, ".pdf"), width=6, height=5)
  print(gg1)
  dev.off()
}